//=============================================================================
// Supply Check Button, for when the recipe isn't always clear!
//=============================================================================
class SupplyCheckButton extends DeusExDecoration;

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

//the new variable
var() BakeButton BakeButton;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
        /*reliable if ( Role < ROLE_Authority )
                ItemPrice, bInModMode;*/
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
local Actor A;
local MSMTLPlayer P;
local Credits C;
local int j;
local OvenLocPoint OvenLoc;
local PlacementLocPoint PlacementLoc;
local vector PlacementLocation, RegisterLocation;
local int xmode;
local int CookedSoFar; //how many have we cooked?
local class<DeusExPickup> tocook;
local DeusExPickup ToCookClass, cookedshit;
local int Spices, Chocolate, Sugar, Soy, Fruit, Bread;
local bool bBaked;
local int reasonablenum;
local string ToCookName;
local float CookingMult;
local string spicescost, chocolatecost, sugarcost, soycost, fruitcost, breadcost;
local string totalcost;

  P = MSMTLPlayer(Frobber);

if ((P != None) && (P.InHand.IsA('MSMTLCookingPot2')))
{
 xmode = int(MSMTLCookingPot2(P.InHand).GetPropertyText("xmode"));
 tocook = BakeButton.CookableItems[xmode];
 Spices = BakeButton.NumSpices[xmode]; 
 Chocolate = BakeButton.NumChocolate[xmode];
 Sugar = BakeButton.NumSugar[xmode];
 Soy = BakeButton.NumSoy[xmode];
 Fruit = BakeButton.NumFruit[xmode];
 Bread = BakeButton.NumBread[xmode];
 tocookclass = Spawn(tocook,,,Location);
 tocookclass.bHidden = True;
 reasonablenum = Min(tocookclass.maxcopies, BakeButton.NumToCook); //make sure we don't cook more than we can carry...
 tocookname = ToCookClass.GetPropertyText("ItemName");
 tocookclass.destroy();
 CookingMult = BakeButton.cookingskillmult;
}

if (Spices > 0) spicescost = int(Spices * CookingMult * reasonablenum)$" Spices ";
if (Chocolate > 0) chocolatecost = int(Chocolate * CookingMult * reasonablenum)$" Chocolate ";
if (Sugar > 0) sugarcost = int(Sugar * CookingMult * reasonablenum)$" Sugar ";
if (Soy > 0) soycost = int(Soy * CookingMult * reasonablenum)$" Soy ";
if (Fruit > 0) fruitcost = int(Fruit * CookingMult * reasonablenum)$" Fruit ";
if (Bread > 0) breadcost = int(Bread * CookingMult * reasonablenum)$" Bread ";
totalcost = spicescost$chocolatecost$sugarcost$soycost$fruitcost$breadcost;

if (totalcost ~= "") totalcost = "nothing";
if (tocookname ~= "")
{
tocookname = "nothing";
reasonablenum = 0;
}

P.ClientMessage("|p4You would cook "$reasonablenum$" "$tocookname$"s at the cost of "$totalcost$"!");


}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     bCollideActors=True
     bBlockActors=True
     bProjTarget=True
     ItemName="|p3Supply Check Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
     MultiSkins(0)=Texture'MSShopping1_2.Skins.PriceCheckButton'
}
